var Se = Object.defineProperty;
var Ce = (o, e, t) => e in o ? Se(o, e, { enumerable: !0, configurable: !0, writable: !0, value: t }) : o[e] = t;
var d = (o, e, t) => Ce(o, typeof e != "symbol" ? e + "" : e, t);
/**
 * @license
 * Copyright 2019 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const B = globalThis, re = B.ShadowRoot && (B.ShadyCSS === void 0 || B.ShadyCSS.nativeShadow) && "adoptedStyleSheets" in Document.prototype && "replace" in CSSStyleSheet.prototype, ie = Symbol(), se = /* @__PURE__ */ new WeakMap();
let ve = class {
  constructor(e, t, r) {
    if (this._$cssResult$ = !0, r !== ie) throw Error("CSSResult is not constructable. Use `unsafeCSS` or `css` instead.");
    this.cssText = e, this.t = t;
  }
  get styleSheet() {
    let e = this.o;
    const t = this.t;
    if (re && e === void 0) {
      const r = t !== void 0 && t.length === 1;
      r && (e = se.get(t)), e === void 0 && ((this.o = e = new CSSStyleSheet()).replaceSync(this.cssText), r && se.set(t, e));
    }
    return e;
  }
  toString() {
    return this.cssText;
  }
};
const ze = (o) => new ve(typeof o == "string" ? o : o + "", void 0, ie), f = (o, ...e) => {
  const t = o.length === 1 ? o[0] : e.reduce((r, i, n) => r + ((s) => {
    if (s._$cssResult$ === !0) return s.cssText;
    if (typeof s == "number") return s;
    throw Error("Value passed to 'css' function must be a 'css' function result: " + s + ". Use 'unsafeCSS' to pass non-literal values, but take care to ensure page security.");
  })(i) + o[n + 1], o[0]);
  return new ve(t, o, ie);
}, Me = (o, e) => {
  if (re) o.adoptedStyleSheets = e.map((t) => t instanceof CSSStyleSheet ? t : t.styleSheet);
  else for (const t of e) {
    const r = document.createElement("style"), i = B.litNonce;
    i !== void 0 && r.setAttribute("nonce", i), r.textContent = t.cssText, o.appendChild(r);
  }
}, ne = re ? (o) => o : (o) => o instanceof CSSStyleSheet ? ((e) => {
  let t = "";
  for (const r of e.cssRules) t += r.cssText;
  return ze(t);
})(o) : o;
/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const { is: Te, defineProperty: Pe, getOwnPropertyDescriptor: Ue, getOwnPropertyNames: Oe, getOwnPropertySymbols: Re, getPrototypeOf: He } = Object, y = globalThis, ae = y.trustedTypes, Be = ae ? ae.emptyScript : "", D = y.reactiveElementPolyfillSupport, M = (o, e) => o, F = { toAttribute(o, e) {
  switch (e) {
    case Boolean:
      o = o ? Be : null;
      break;
    case Object:
    case Array:
      o = o == null ? o : JSON.stringify(o);
  }
  return o;
}, fromAttribute(o, e) {
  let t = o;
  switch (e) {
    case Boolean:
      t = o !== null;
      break;
    case Number:
      t = o === null ? null : Number(o);
      break;
    case Object:
    case Array:
      try {
        t = JSON.parse(o);
      } catch {
        t = null;
      }
  }
  return t;
} }, be = (o, e) => !Te(o, e), le = { attribute: !0, type: String, converter: F, reflect: !1, useDefault: !1, hasChanged: be };
Symbol.metadata ?? (Symbol.metadata = Symbol("metadata")), y.litPropertyMetadata ?? (y.litPropertyMetadata = /* @__PURE__ */ new WeakMap());
let E = class extends HTMLElement {
  static addInitializer(e) {
    this._$Ei(), (this.l ?? (this.l = [])).push(e);
  }
  static get observedAttributes() {
    return this.finalize(), this._$Eh && [...this._$Eh.keys()];
  }
  static createProperty(e, t = le) {
    if (t.state && (t.attribute = !1), this._$Ei(), this.prototype.hasOwnProperty(e) && ((t = Object.create(t)).wrapped = !0), this.elementProperties.set(e, t), !t.noAccessor) {
      const r = Symbol(), i = this.getPropertyDescriptor(e, r, t);
      i !== void 0 && Pe(this.prototype, e, i);
    }
  }
  static getPropertyDescriptor(e, t, r) {
    const { get: i, set: n } = Ue(this.prototype, e) ?? { get() {
      return this[t];
    }, set(s) {
      this[t] = s;
    } };
    return { get: i, set(s) {
      const l = i == null ? void 0 : i.call(this);
      n == null || n.call(this, s), this.requestUpdate(e, l, r);
    }, configurable: !0, enumerable: !0 };
  }
  static getPropertyOptions(e) {
    return this.elementProperties.get(e) ?? le;
  }
  static _$Ei() {
    if (this.hasOwnProperty(M("elementProperties"))) return;
    const e = He(this);
    e.finalize(), e.l !== void 0 && (this.l = [...e.l]), this.elementProperties = new Map(e.elementProperties);
  }
  static finalize() {
    if (this.hasOwnProperty(M("finalized"))) return;
    if (this.finalized = !0, this._$Ei(), this.hasOwnProperty(M("properties"))) {
      const t = this.properties, r = [...Oe(t), ...Re(t)];
      for (const i of r) this.createProperty(i, t[i]);
    }
    const e = this[Symbol.metadata];
    if (e !== null) {
      const t = litPropertyMetadata.get(e);
      if (t !== void 0) for (const [r, i] of t) this.elementProperties.set(r, i);
    }
    this._$Eh = /* @__PURE__ */ new Map();
    for (const [t, r] of this.elementProperties) {
      const i = this._$Eu(t, r);
      i !== void 0 && this._$Eh.set(i, t);
    }
    this.elementStyles = this.finalizeStyles(this.styles);
  }
  static finalizeStyles(e) {
    const t = [];
    if (Array.isArray(e)) {
      const r = new Set(e.flat(1 / 0).reverse());
      for (const i of r) t.unshift(ne(i));
    } else e !== void 0 && t.push(ne(e));
    return t;
  }
  static _$Eu(e, t) {
    const r = t.attribute;
    return r === !1 ? void 0 : typeof r == "string" ? r : typeof e == "string" ? e.toLowerCase() : void 0;
  }
  constructor() {
    super(), this._$Ep = void 0, this.isUpdatePending = !1, this.hasUpdated = !1, this._$Em = null, this._$Ev();
  }
  _$Ev() {
    var e;
    this._$ES = new Promise((t) => this.enableUpdating = t), this._$AL = /* @__PURE__ */ new Map(), this._$E_(), this.requestUpdate(), (e = this.constructor.l) == null || e.forEach((t) => t(this));
  }
  addController(e) {
    var t;
    (this._$EO ?? (this._$EO = /* @__PURE__ */ new Set())).add(e), this.renderRoot !== void 0 && this.isConnected && ((t = e.hostConnected) == null || t.call(e));
  }
  removeController(e) {
    var t;
    (t = this._$EO) == null || t.delete(e);
  }
  _$E_() {
    const e = /* @__PURE__ */ new Map(), t = this.constructor.elementProperties;
    for (const r of t.keys()) this.hasOwnProperty(r) && (e.set(r, this[r]), delete this[r]);
    e.size > 0 && (this._$Ep = e);
  }
  createRenderRoot() {
    const e = this.shadowRoot ?? this.attachShadow(this.constructor.shadowRootOptions);
    return Me(e, this.constructor.elementStyles), e;
  }
  connectedCallback() {
    var e;
    this.renderRoot ?? (this.renderRoot = this.createRenderRoot()), this.enableUpdating(!0), (e = this._$EO) == null || e.forEach((t) => {
      var r;
      return (r = t.hostConnected) == null ? void 0 : r.call(t);
    });
  }
  enableUpdating(e) {
  }
  disconnectedCallback() {
    var e;
    (e = this._$EO) == null || e.forEach((t) => {
      var r;
      return (r = t.hostDisconnected) == null ? void 0 : r.call(t);
    });
  }
  attributeChangedCallback(e, t, r) {
    this._$AK(e, r);
  }
  _$ET(e, t) {
    var n;
    const r = this.constructor.elementProperties.get(e), i = this.constructor._$Eu(e, r);
    if (i !== void 0 && r.reflect === !0) {
      const s = (((n = r.converter) == null ? void 0 : n.toAttribute) !== void 0 ? r.converter : F).toAttribute(t, r.type);
      this._$Em = e, s == null ? this.removeAttribute(i) : this.setAttribute(i, s), this._$Em = null;
    }
  }
  _$AK(e, t) {
    var n, s;
    const r = this.constructor, i = r._$Eh.get(e);
    if (i !== void 0 && this._$Em !== i) {
      const l = r.getPropertyOptions(i), a = typeof l.converter == "function" ? { fromAttribute: l.converter } : ((n = l.converter) == null ? void 0 : n.fromAttribute) !== void 0 ? l.converter : F;
      this._$Em = i;
      const p = a.fromAttribute(t, l.type);
      this[i] = p ?? ((s = this._$Ej) == null ? void 0 : s.get(i)) ?? p, this._$Em = null;
    }
  }
  requestUpdate(e, t, r, i = !1, n) {
    var s;
    if (e !== void 0) {
      const l = this.constructor;
      if (i === !1 && (n = this[e]), r ?? (r = l.getPropertyOptions(e)), !((r.hasChanged ?? be)(n, t) || r.useDefault && r.reflect && n === ((s = this._$Ej) == null ? void 0 : s.get(e)) && !this.hasAttribute(l._$Eu(e, r)))) return;
      this.C(e, t, r);
    }
    this.isUpdatePending === !1 && (this._$ES = this._$EP());
  }
  C(e, t, { useDefault: r, reflect: i, wrapped: n }, s) {
    r && !(this._$Ej ?? (this._$Ej = /* @__PURE__ */ new Map())).has(e) && (this._$Ej.set(e, s ?? t ?? this[e]), n !== !0 || s !== void 0) || (this._$AL.has(e) || (this.hasUpdated || r || (t = void 0), this._$AL.set(e, t)), i === !0 && this._$Em !== e && (this._$Eq ?? (this._$Eq = /* @__PURE__ */ new Set())).add(e));
  }
  async _$EP() {
    this.isUpdatePending = !0;
    try {
      await this._$ES;
    } catch (t) {
      Promise.reject(t);
    }
    const e = this.scheduleUpdate();
    return e != null && await e, !this.isUpdatePending;
  }
  scheduleUpdate() {
    return this.performUpdate();
  }
  performUpdate() {
    var r;
    if (!this.isUpdatePending) return;
    if (!this.hasUpdated) {
      if (this.renderRoot ?? (this.renderRoot = this.createRenderRoot()), this._$Ep) {
        for (const [n, s] of this._$Ep) this[n] = s;
        this._$Ep = void 0;
      }
      const i = this.constructor.elementProperties;
      if (i.size > 0) for (const [n, s] of i) {
        const { wrapped: l } = s, a = this[n];
        l !== !0 || this._$AL.has(n) || a === void 0 || this.C(n, void 0, s, a);
      }
    }
    let e = !1;
    const t = this._$AL;
    try {
      e = this.shouldUpdate(t), e ? (this.willUpdate(t), (r = this._$EO) == null || r.forEach((i) => {
        var n;
        return (n = i.hostUpdate) == null ? void 0 : n.call(i);
      }), this.update(t)) : this._$EM();
    } catch (i) {
      throw e = !1, this._$EM(), i;
    }
    e && this._$AE(t);
  }
  willUpdate(e) {
  }
  _$AE(e) {
    var t;
    (t = this._$EO) == null || t.forEach((r) => {
      var i;
      return (i = r.hostUpdated) == null ? void 0 : i.call(r);
    }), this.hasUpdated || (this.hasUpdated = !0, this.firstUpdated(e)), this.updated(e);
  }
  _$EM() {
    this._$AL = /* @__PURE__ */ new Map(), this.isUpdatePending = !1;
  }
  get updateComplete() {
    return this.getUpdateComplete();
  }
  getUpdateComplete() {
    return this._$ES;
  }
  shouldUpdate(e) {
    return !0;
  }
  update(e) {
    this._$Eq && (this._$Eq = this._$Eq.forEach((t) => this._$ET(t, this[t]))), this._$EM();
  }
  updated(e) {
  }
  firstUpdated(e) {
  }
};
E.elementStyles = [], E.shadowRootOptions = { mode: "open" }, E[M("elementProperties")] = /* @__PURE__ */ new Map(), E[M("finalized")] = /* @__PURE__ */ new Map(), D == null || D({ ReactiveElement: E }), (y.reactiveElementVersions ?? (y.reactiveElementVersions = [])).push("2.1.2");
/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const T = globalThis, ce = (o) => o, N = T.trustedTypes, de = N ? N.createPolicy("lit-html", { createHTML: (o) => o }) : void 0, xe = "$lit$", x = `lit$${Math.random().toFixed(9).slice(2)}$`, ye = "?" + x, Ne = `<${ye}>`, A = document, P = () => A.createComment(""), U = (o) => o === null || typeof o != "object" && typeof o != "function", oe = Array.isArray, je = (o) => oe(o) || typeof (o == null ? void 0 : o[Symbol.iterator]) == "function", I = `[ 	
\f\r]`, z = /<(?:(!--|\/[^a-zA-Z])|(\/?[a-zA-Z][^>\s]*)|(\/?$))/g, pe = /-->/g, he = />/g, w = RegExp(`>|${I}(?:([^\\s"'>=/]+)(${I}*=${I}*(?:[^ 	
\f\r"'\`<>=]|("|')|))|$)`, "g"), ue = /'/g, ge = /"/g, we = /^(?:script|style|textarea|title)$/i, $e = (o) => (e, ...t) => ({ _$litType$: o, strings: e, values: t }), c = $e(1), $ = $e(2), S = Symbol.for("lit-noChange"), g = Symbol.for("lit-nothing"), me = /* @__PURE__ */ new WeakMap(), _ = A.createTreeWalker(A, 129);
function _e(o, e) {
  if (!oe(o) || !o.hasOwnProperty("raw")) throw Error("invalid template strings array");
  return de !== void 0 ? de.createHTML(e) : e;
}
const De = (o, e) => {
  const t = o.length - 1, r = [];
  let i, n = e === 2 ? "<svg>" : e === 3 ? "<math>" : "", s = z;
  for (let l = 0; l < t; l++) {
    const a = o[l];
    let p, u, h = -1, v = 0;
    for (; v < a.length && (s.lastIndex = v, u = s.exec(a), u !== null); ) v = s.lastIndex, s === z ? u[1] === "!--" ? s = pe : u[1] !== void 0 ? s = he : u[2] !== void 0 ? (we.test(u[2]) && (i = RegExp("</" + u[2], "g")), s = w) : u[3] !== void 0 && (s = w) : s === w ? u[0] === ">" ? (s = i ?? z, h = -1) : u[1] === void 0 ? h = -2 : (h = s.lastIndex - u[2].length, p = u[1], s = u[3] === void 0 ? w : u[3] === '"' ? ge : ue) : s === ge || s === ue ? s = w : s === pe || s === he ? s = z : (s = w, i = void 0);
    const b = s === w && o[l + 1].startsWith("/>") ? " " : "";
    n += s === z ? a + Ne : h >= 0 ? (r.push(p), a.slice(0, h) + xe + a.slice(h) + x + b) : a + x + (h === -2 ? l : b);
  }
  return [_e(o, n + (o[t] || "<?>") + (e === 2 ? "</svg>" : e === 3 ? "</math>" : "")), r];
};
class O {
  constructor({ strings: e, _$litType$: t }, r) {
    let i;
    this.parts = [];
    let n = 0, s = 0;
    const l = e.length - 1, a = this.parts, [p, u] = De(e, t);
    if (this.el = O.createElement(p, r), _.currentNode = this.el.content, t === 2 || t === 3) {
      const h = this.el.content.firstChild;
      h.replaceWith(...h.childNodes);
    }
    for (; (i = _.nextNode()) !== null && a.length < l; ) {
      if (i.nodeType === 1) {
        if (i.hasAttributes()) for (const h of i.getAttributeNames()) if (h.endsWith(xe)) {
          const v = u[s++], b = i.getAttribute(h).split(x), H = /([.?@])?(.*)/.exec(v);
          a.push({ type: 1, index: n, name: H[2], strings: b, ctor: H[1] === "." ? Le : H[1] === "?" ? Ve : H[1] === "@" ? Fe : j }), i.removeAttribute(h);
        } else h.startsWith(x) && (a.push({ type: 6, index: n }), i.removeAttribute(h));
        if (we.test(i.tagName)) {
          const h = i.textContent.split(x), v = h.length - 1;
          if (v > 0) {
            i.textContent = N ? N.emptyScript : "";
            for (let b = 0; b < v; b++) i.append(h[b], P()), _.nextNode(), a.push({ type: 2, index: ++n });
            i.append(h[v], P());
          }
        }
      } else if (i.nodeType === 8) if (i.data === ye) a.push({ type: 2, index: n });
      else {
        let h = -1;
        for (; (h = i.data.indexOf(x, h + 1)) !== -1; ) a.push({ type: 7, index: n }), h += x.length - 1;
      }
      n++;
    }
  }
  static createElement(e, t) {
    const r = A.createElement("template");
    return r.innerHTML = e, r;
  }
}
function C(o, e, t = o, r) {
  var s, l;
  if (e === S) return e;
  let i = r !== void 0 ? (s = t._$Co) == null ? void 0 : s[r] : t._$Cl;
  const n = U(e) ? void 0 : e._$litDirective$;
  return (i == null ? void 0 : i.constructor) !== n && ((l = i == null ? void 0 : i._$AO) == null || l.call(i, !1), n === void 0 ? i = void 0 : (i = new n(o), i._$AT(o, t, r)), r !== void 0 ? (t._$Co ?? (t._$Co = []))[r] = i : t._$Cl = i), i !== void 0 && (e = C(o, i._$AS(o, e.values), i, r)), e;
}
class Ie {
  constructor(e, t) {
    this._$AV = [], this._$AN = void 0, this._$AD = e, this._$AM = t;
  }
  get parentNode() {
    return this._$AM.parentNode;
  }
  get _$AU() {
    return this._$AM._$AU;
  }
  u(e) {
    const { el: { content: t }, parts: r } = this._$AD, i = ((e == null ? void 0 : e.creationScope) ?? A).importNode(t, !0);
    _.currentNode = i;
    let n = _.nextNode(), s = 0, l = 0, a = r[0];
    for (; a !== void 0; ) {
      if (s === a.index) {
        let p;
        a.type === 2 ? p = new R(n, n.nextSibling, this, e) : a.type === 1 ? p = new a.ctor(n, a.name, a.strings, this, e) : a.type === 6 && (p = new Ye(n, this, e)), this._$AV.push(p), a = r[++l];
      }
      s !== (a == null ? void 0 : a.index) && (n = _.nextNode(), s++);
    }
    return _.currentNode = A, i;
  }
  p(e) {
    let t = 0;
    for (const r of this._$AV) r !== void 0 && (r.strings !== void 0 ? (r._$AI(e, r, t), t += r.strings.length - 2) : r._$AI(e[t])), t++;
  }
}
class R {
  get _$AU() {
    var e;
    return ((e = this._$AM) == null ? void 0 : e._$AU) ?? this._$Cv;
  }
  constructor(e, t, r, i) {
    this.type = 2, this._$AH = g, this._$AN = void 0, this._$AA = e, this._$AB = t, this._$AM = r, this.options = i, this._$Cv = (i == null ? void 0 : i.isConnected) ?? !0;
  }
  get parentNode() {
    let e = this._$AA.parentNode;
    const t = this._$AM;
    return t !== void 0 && (e == null ? void 0 : e.nodeType) === 11 && (e = t.parentNode), e;
  }
  get startNode() {
    return this._$AA;
  }
  get endNode() {
    return this._$AB;
  }
  _$AI(e, t = this) {
    e = C(this, e, t), U(e) ? e === g || e == null || e === "" ? (this._$AH !== g && this._$AR(), this._$AH = g) : e !== this._$AH && e !== S && this._(e) : e._$litType$ !== void 0 ? this.$(e) : e.nodeType !== void 0 ? this.T(e) : je(e) ? this.k(e) : this._(e);
  }
  O(e) {
    return this._$AA.parentNode.insertBefore(e, this._$AB);
  }
  T(e) {
    this._$AH !== e && (this._$AR(), this._$AH = this.O(e));
  }
  _(e) {
    this._$AH !== g && U(this._$AH) ? this._$AA.nextSibling.data = e : this.T(A.createTextNode(e)), this._$AH = e;
  }
  $(e) {
    var n;
    const { values: t, _$litType$: r } = e, i = typeof r == "number" ? this._$AC(e) : (r.el === void 0 && (r.el = O.createElement(_e(r.h, r.h[0]), this.options)), r);
    if (((n = this._$AH) == null ? void 0 : n._$AD) === i) this._$AH.p(t);
    else {
      const s = new Ie(i, this), l = s.u(this.options);
      s.p(t), this.T(l), this._$AH = s;
    }
  }
  _$AC(e) {
    let t = me.get(e.strings);
    return t === void 0 && me.set(e.strings, t = new O(e)), t;
  }
  k(e) {
    oe(this._$AH) || (this._$AH = [], this._$AR());
    const t = this._$AH;
    let r, i = 0;
    for (const n of e) i === t.length ? t.push(r = new R(this.O(P()), this.O(P()), this, this.options)) : r = t[i], r._$AI(n), i++;
    i < t.length && (this._$AR(r && r._$AB.nextSibling, i), t.length = i);
  }
  _$AR(e = this._$AA.nextSibling, t) {
    var r;
    for ((r = this._$AP) == null ? void 0 : r.call(this, !1, !0, t); e !== this._$AB; ) {
      const i = ce(e).nextSibling;
      ce(e).remove(), e = i;
    }
  }
  setConnected(e) {
    var t;
    this._$AM === void 0 && (this._$Cv = e, (t = this._$AP) == null || t.call(this, e));
  }
}
class j {
  get tagName() {
    return this.element.tagName;
  }
  get _$AU() {
    return this._$AM._$AU;
  }
  constructor(e, t, r, i, n) {
    this.type = 1, this._$AH = g, this._$AN = void 0, this.element = e, this.name = t, this._$AM = i, this.options = n, r.length > 2 || r[0] !== "" || r[1] !== "" ? (this._$AH = Array(r.length - 1).fill(new String()), this.strings = r) : this._$AH = g;
  }
  _$AI(e, t = this, r, i) {
    const n = this.strings;
    let s = !1;
    if (n === void 0) e = C(this, e, t, 0), s = !U(e) || e !== this._$AH && e !== S, s && (this._$AH = e);
    else {
      const l = e;
      let a, p;
      for (e = n[0], a = 0; a < n.length - 1; a++) p = C(this, l[r + a], t, a), p === S && (p = this._$AH[a]), s || (s = !U(p) || p !== this._$AH[a]), p === g ? e = g : e !== g && (e += (p ?? "") + n[a + 1]), this._$AH[a] = p;
    }
    s && !i && this.j(e);
  }
  j(e) {
    e === g ? this.element.removeAttribute(this.name) : this.element.setAttribute(this.name, e ?? "");
  }
}
class Le extends j {
  constructor() {
    super(...arguments), this.type = 3;
  }
  j(e) {
    this.element[this.name] = e === g ? void 0 : e;
  }
}
class Ve extends j {
  constructor() {
    super(...arguments), this.type = 4;
  }
  j(e) {
    this.element.toggleAttribute(this.name, !!e && e !== g);
  }
}
class Fe extends j {
  constructor(e, t, r, i, n) {
    super(e, t, r, i, n), this.type = 5;
  }
  _$AI(e, t = this) {
    if ((e = C(this, e, t, 0) ?? g) === S) return;
    const r = this._$AH, i = e === g && r !== g || e.capture !== r.capture || e.once !== r.once || e.passive !== r.passive, n = e !== g && (r === g || i);
    i && this.element.removeEventListener(this.name, this, r), n && this.element.addEventListener(this.name, this, e), this._$AH = e;
  }
  handleEvent(e) {
    var t;
    typeof this._$AH == "function" ? this._$AH.call(((t = this.options) == null ? void 0 : t.host) ?? this.element, e) : this._$AH.handleEvent(e);
  }
}
class Ye {
  constructor(e, t, r) {
    this.element = e, this.type = 6, this._$AN = void 0, this._$AM = t, this.options = r;
  }
  get _$AU() {
    return this._$AM._$AU;
  }
  _$AI(e) {
    C(this, e);
  }
}
const L = T.litHtmlPolyfillSupport;
L == null || L(O, R), (T.litHtmlVersions ?? (T.litHtmlVersions = [])).push("3.3.2");
const qe = (o, e, t) => {
  const r = (t == null ? void 0 : t.renderBefore) ?? e;
  let i = r._$litPart$;
  if (i === void 0) {
    const n = (t == null ? void 0 : t.renderBefore) ?? null;
    r._$litPart$ = i = new R(e.insertBefore(P(), n), n, void 0, t ?? {});
  }
  return i._$AI(o), i;
};
/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const k = globalThis;
class m extends E {
  constructor() {
    super(...arguments), this.renderOptions = { host: this }, this._$Do = void 0;
  }
  createRenderRoot() {
    var t;
    const e = super.createRenderRoot();
    return (t = this.renderOptions).renderBefore ?? (t.renderBefore = e.firstChild), e;
  }
  update(e) {
    const t = this.render();
    this.hasUpdated || (this.renderOptions.isConnected = this.isConnected), super.update(e), this._$Do = qe(t, this.renderRoot, this.renderOptions);
  }
  connectedCallback() {
    var e;
    super.connectedCallback(), (e = this._$Do) == null || e.setConnected(!0);
  }
  disconnectedCallback() {
    var e;
    super.disconnectedCallback(), (e = this._$Do) == null || e.setConnected(!1);
  }
  render() {
    return S;
  }
}
var fe;
m._$litElement$ = !0, m.finalized = !0, (fe = k.litElementHydrateSupport) == null || fe.call(k, { LitElement: m });
const V = k.litElementPolyfillSupport;
V == null || V({ LitElement: m });
(k.litElementVersions ?? (k.litElementVersions = [])).push("4.2.2");
class Y extends m {
  render() {
    return c`
      ${this.imageUrl ? c`<img class="card-image" src="${this.imageUrl}" alt="${this.imageAlt || ""}" />` : ""}

      <slot name="header" class="card-header-slot"></slot>

      <div class="card-body">
        <slot></slot>
      </div>

      <slot name="footer" class="card-footer-slot"></slot>
    `;
  }
}
d(Y, "styles", f`
    :host {
      --luumicore-card-bg: var(--luumicore-secondary, #fff);
      --luumicore-card-border-color: var(--luumicore-secondary, #fff);
      --luumicore-card-border-radius: var(--luumicore-border-radius, 1rem);
      --luumicore-card-shadow: var(--luumicore-shadow, .25rem .25rem 1rem rgba(0,0,0,0.2));
      --luumicore-card-spacing: var(--luumicore-element-spacing, 2rem);

      display: block;
      border: 1px solid var(--luumicore-card-border-color);
      border-radius: var(--luumicore-card-border-radius);
      overflow: hidden;
      background-color: var(--luumicore-card-bg);
      box-shadow: var(--luumicore-card-shadow);
    }

    :host(:not(:last-child)) {
      margin-bottom: var(--luumicore-card-spacing);
    }

    .card-image {
      width: 100%;
      height: auto;
      display: block;
    }

    .card-header {
      padding: var(--luumicore-spacing, 16px);
      border-bottom: 1px solid var(--luumicore-border-color, #ddd);
      font-weight: bold;
      background-color: var(--luumicore-header-bg, #f8f9fa);
    }

    .card-body {
      padding: var(--luumicore-spacing, 16px);
    }

    .card-footer {
      padding: var(--luumicore-spacing, 16px);
      border-top: 1px solid var(--luumicore-border-color, #ddd);
      background-color: var(--luumicore-footer-bg, #f8f9fa);
    }
  `), d(Y, "properties", {
  imageUrl: { type: String, attribute: "image-url" },
  imageAlt: { type: String, attribute: "image-alt" }
});
customElements.define("luumicore-card", Y);
class ke extends m {
  render() {
    return c`
      <ul>
        <slot></slot>
      </ul>
    `;
  }
}
d(ke, "styles", f`
    :host {
      display: block;
    }

    ul {
      list-style: none;
      padding: 0;
      margin: 0;
      border: 1px solid var(--luumicore-border-color, #ddd);
      border-radius: var(--luumicore-border-radius, 8px);
      overflow: hidden;
    }
  `);
customElements.define("luumicore-list", ke);
class Ae extends m {
  render() {
    return c`
      <div class="item-container">
        <div class="content">
          <slot></slot>
        </div>

        <div class="actions">
          <slot name="actions"></slot>
        </div>

        <div class="main-action">
          <slot name="main-action"></slot>
        </div>
      </div>
    `;
  }
}
d(Ae, "styles", f`
    :host {
      display: block;
      border-bottom: 1px solid var(--luumicore-border-color, #ddd);
      background-color: var(--luumicore-list-bg, #fff);
    }

    :host(:last-child) {
      border-bottom: none;
    }

    .item-container {
      display: flex;
      align-items: center;
      padding: var(--luumicore-spacing, 12px) var(--luumicore-spacing, 16px);
      gap: var(--luumicore-spacing, 16px);
    }

    .content {
      flex: 1;
      min-width: 0; /* Allow text truncation */
    }

    .actions {
      display: flex;
      align-items: center;
      gap: 8px;
    }

    .main-action {
      margin-left: auto;
    }
  `);
customElements.define("luumicore-list-item", Ae);
class q extends m {
  _getIcon(e) {
    const t = e.toLowerCase();
    return t === "pdf" ? c`<svg class="type-pdf" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path><polyline points="14 2 14 8 20 8"></polyline><path d="M9 15l3 3 3-3"></path><path d="M12 18v-6"></path><text x="6" y="22" font-size="6" font-weight="bold" fill="currentColor" stroke="none">PDF</text></svg>` : t === "docx" || t === "doc" ? c`<svg class="type-doc" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path><polyline points="14 2 14 8 20 8"></polyline><line x1="16" y1="13" x2="8" y2="13"></line><line x1="16" y1="17" x2="8" y2="17"></line><line x1="10" y1="9" x2="8" y2="9"></line></svg>` : c`<svg class="type-default" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M13 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V9z"></path><polyline points="13 2 13 9 20 9"></polyline></svg>`;
  }
  render() {
    return c`
            <div class="file-card ${this.file.isNew ? "has-new" : ""}">
                ${this.file.isNew ? c`<div class="new-dot"></div>` : ""}

                <div class="icon-container">
                    ${this._getIcon(this.file.type)}
                </div>

                <div class="file-info">
                    <div class="file-name">${this.file.name}</div>
                    <div class="file-meta-row">
                        <div class="file-meta">${this.file.date} &nbsp; ${this.file.size}</div>
                        <div class="tags-container">
                            <slot name="tags"></slot>
                        </div>
                    </div>
                </div>

                <div class="download-btn">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"></path><polyline points="7 10 12 15 17 10"></polyline><line x1="12" y1="15" x2="12" y2="3"></line></svg>
                </div>
            </div>
        `;
  }
}
d(q, "properties", {
  file: { type: Object }
  // { name, date, size, type, isNew }
}), d(q, "styles", f`
        :host {
            display: block;
            margin-bottom: 12px;
        }
        .file-card {
            background-color: var(--bg-card); /* Standard: Grau für gelesene Dateien */
            border-radius: var(--radius-sm);
            padding: 12px 16px;
            display: flex;
            align-items: center;
            border: 1px solid var(--border-color);
            box-shadow: var(--shadow-sm);
            position: relative;
            flex-wrap: wrap;
        }

        /* UPDATE: Styling für neue Dateien (Weißer BG + Farbiger Rand) */
        .file-card.has-new {
            background-color: var(--bg-white);
            border-color: var(--primary-color);
        }

        .icon-container {
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 16px;
            flex-shrink: 0;
        }
        .icon-container svg {
            width: 32px;
            height: 32px;
        }
        .file-info {
            flex: 1;
            min-width: 0; /* Text truncation fix */
        }
        .file-name {
            font-weight: 400; /* UPDATE: Standard nicht fett */
            font-size: 0.9rem;
            color: var(--text-dark);
            margin-bottom: 4px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        /* UPDATE: Fett nur wenn neu */
        .has-new .file-name {
            font-weight: 700;
        }

        .file-meta-row {
            display: flex;
            align-items: center;
            gap: 12px;
            flex-wrap: wrap;
        }

        .file-meta {
            font-size: 0.75rem;
            color: var(--text-muted);
            line-height: 1; /* Ensure consistent height */
            display: flex;
            align-items: center;
        }
        .download-btn {
            width: 36px;
            height: 36px;
            border: 1px solid var(--primary-color);
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;

            /* UPDATE: Standard Button Style (Weiß) */
            background-color: var(--bg-white);
            color: var(--primary-color);

            cursor: pointer;
            margin-left: 12px;
            flex-shrink: 0;

            /* UPDATE: Transition angepasst an WinzerCard */
            transition: transform 0.1s, background-color 0.2s;
        }

        /* UPDATE: Klick-Effekt hinzugefügt (wie bei WinzerCard) */
        .download-btn:active {
            transform: scale(0.95);
        }

        /* UPDATE: Button Style für neue Dateien (Primärfarbe) */
        .has-new .download-btn {
            background-color: var(--primary-color);
            color: white;
        }

        .download-btn svg {
            width: 20px;
            height: 20px;
        }

        /* New Indicator Dot */
        .new-dot {
            position: absolute;
            left: 6px; /* UPDATE: Position angepasst für fixe Ausrichtung */
            top: 50%;
            transform: translateY(-50%);
            width: 6px;
            height: 6px;
            background-color: var(--primary-color);
            border-radius: 50%;
        }
        /* UPDATE: Padding-Shift entfernt, damit Icons ausgerichtet bleiben */

        /* Type Colors */
        .type-pdf { color: var(--alert-color); }
        .type-doc { color: #2b5797; } /* Word blueish */
        .type-default { color: var(--text-muted); }

        /* Slot for tags */
        .tags-container {
            display: flex;
            align-items: center; /* Ensure tags are vertically centered */
            gap: 8px;
            flex-wrap: wrap;
        }
    `);
customElements.define("winzer-file-card", q);
class W extends m {
  _timeToGridRow(e) {
    if (!e) return 1;
    const [t, r] = e.split(":").map(Number);
    return t * 4 + Math.floor(r / 15) + 1;
  }
  _formatNumber(e) {
    return new Intl.NumberFormat("de-DE").format(e);
  }
  render() {
    const e = Array.from({ length: 24 }, (t, r) => r);
    return c`<div class="scroll-container"><div class="day-grid">${e.map((t) => c`<div class="time-label" style="grid-row: ${t * 4 + 1}">${t.toString().padStart(2, "0")}:00</div>`)}${this.events ? this.events.map((t) => {
      const r = this._timeToGridRow(t.start), i = this._timeToGridRow(t.end), s = i - r <= 2, l = t.total && t.booked >= t.total;
      let a = "", p = c``;
      if (t.total && t.total > 0) {
        const u = Math.min(100, Math.round(t.booked / t.total * 100));
        a = `${this._formatNumber(t.booked)} / ${this._formatNumber(t.total)} kg`, p = c`<div class="progress-track"><div class="progress-fill" style="width: ${u}%;"></div></div>`;
      }
      return c`<div class="event-item ${s ? "short-event" : ""} ${l ? "fully-booked" : ""}" style="grid-row: ${r} / ${i};" title="${t.title}"><div class="event-title">${t.title}</div><div class="event-details-row">${l ? c`<span class="badge-booked-out">Ausgebucht</span>` : ""}${!s || !l ? c`<span class="capacity-text">${a}</span>` : ""}${s && a ? "" : c`<span style="margin-left:8px;">${t.start} - ${t.end}</span>`}</div>${p}</div>`;
    }) : ""}<div class="grid-spacer"></div></div></div>`;
  }
}
d(W, "properties", { events: { type: Array } }), d(W, "styles", f`
        :host { display: block; background: var(--bg-white); border-radius: var(--radius-card); box-shadow: var(--shadow-sm); overflow: hidden; height: 600px; display: flex; flex-direction: column; }
        .scroll-container { flex: 1; overflow-y: auto; position: relative; }
        .day-grid { display: grid; grid-template-columns: 50px 1fr; grid-auto-rows: 20px; background-image: linear-gradient(to bottom, var(--border-color) 1px, transparent 1px); background-size: 100% 80px; background-attachment: local; }
        .time-label { grid-column: 1; text-align: right; padding-right: 10px; font-size: 0.75rem; color: var(--text-muted); line-height: 1; transform: translateY(-50%); margin-top: 1px; }
        .event-item { grid-column: 2; background-color: var(--primary-light); border-left: 4px solid var(--primary-color); border: 1px solid rgba(0,0,0,0.05); border-left-width: 4px; border-radius: 4px; padding: 6px 8px; font-size: 0.8rem; color: var(--primary-color); overflow: hidden; box-shadow: var(--shadow-sm); cursor: pointer; margin-right: 10px; margin-bottom: 2px; display: flex; flex-direction: column; justify-content: flex-start; gap: 4px; transition: transform 0.1s, filter 0.1s; }
        .event-item:active { transform: scale(0.98); filter: brightness(0.95); }
        .event-title { font-weight: 600; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; line-height: 1.2; }
        .event-details-row { display: flex; justify-content: space-between; align-items: center; font-size: 0.7rem; opacity: 0.8; line-height: 1.2; }
        .capacity-text { font-weight: 600; }
        .progress-track { width: 100%; height: 6px; background-color: rgba(255,255,255,0.6); border-radius: 3px; overflow: hidden; margin-top: auto; }
        .progress-fill { height: 100%; background-color: var(--primary-color); border-radius: 3px; transition: width 0.3s ease; }
        .event-item.fully-booked { border-color: var(--alert-color); border-left-width: 4px; background-color: var(--alert-light); color: #b71c1c; }
        .event-item.fully-booked .progress-fill { background-color: var(--alert-color); }
        .badge-booked-out { background-color: var(--alert-color); color: white; font-size: 0.6rem; padding: 2px 6px; border-radius: 4px; font-weight: bold; text-transform: uppercase; margin-right: 6px; display: inline-block; }
        .event-item.short-event { flex-direction: row; align-items: center; justify-content: space-between; padding: 0 6px; padding-bottom: 4px; gap: 8px; position: relative; }
        .event-item.short-event .event-title { flex: 1; min-width: 0; }
        .event-item.short-event .event-details-row { flex-shrink: 0; display: flex; align-items: center; }
        .event-item.short-event .progress-track { position: absolute; bottom: 0; left: 0; right: 0; width: 100%; height: 2px; margin-top: 0; border-radius: 0; background-color: rgba(0,0,0,0.05); }
        .event-item.short-event .progress-fill { border-radius: 0; }
        .grid-spacer { grid-column: 1 / -1; grid-row: 97; height: 20px; }
    `);
customElements.define("winzer-day-view", W);
class G extends m {
  _handleItemClick(e) {
    this.dispatchEvent(new CustomEvent("item-click", { detail: { action: e.action, label: e.label }, bubbles: !0, composed: !0 }));
  }
  render() {
    return !this.items || this.items.length === 0 ? c`` : c`<div class="menu-group">${this.items.map((e) => c`<div class="menu-item" @click="${() => this._handleItemClick(e)}"><div class="menu-icon"><svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">${e.icon}</svg></div><span>${e.label}</span><svg class="chevron" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M9 18l6-6-6-6"/></svg></div>`)}</div>`;
  }
}
d(G, "properties", { items: { type: Array } }), d(G, "styles", f`
        :host { display: block; margin-bottom: 20px; }
        .menu-group { background-color: var(--bg-card); border-radius: var(--radius-sm); overflow: hidden; box-shadow: var(--shadow-sm); }
        .menu-item { display: flex; align-items: center; padding: 16px 20px; cursor: pointer; background: var(--bg-white); border-bottom: 1px solid var(--border-color); font-size: 0.95rem; font-weight: 600; color: var(--text-dark); }
        .menu-item:last-child { border-bottom: none; }
        .menu-item:active { background-color: #f9f9f9; }
        .menu-icon { width: 24px; height: 24px; margin-right: 16px; color: var(--primary-color); display: flex; justify-content: center; align-items: center; }
        .menu-icon svg { width: 100%; height: 100%; display: block; }
        .chevron { margin-left: auto; color: var(--primary-color); width: 18px; height: 18px; }
    `);
customElements.define("winzer-menu-group", G);
class Z extends m {
  _close() {
    this.dispatchEvent(new CustomEvent("close"));
  }
  render() {
    return c`<div class="backdrop" @click="${(e) => e.target.classList.contains("backdrop") && this._close()}"><div class="modal-container"><div class="modal-header"><span>${this.title}</span><div class="close-btn" @click="${this._close}"><svg viewBox="0 0 24 24"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg></div></div><slot></slot></div></div>`;
  }
}
d(Z, "properties", { open: { type: Boolean }, title: { type: String } }), d(Z, "styles", f`
        :host { display: block; }
        .backdrop { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(var(--primary-rgb), 0.85); backdrop-filter: blur(4px); z-index: 1000; display: flex; justify-content: center; align-items: flex-start; padding-top: 120px; opacity: 0; pointer-events: none; transition: opacity 0.3s ease; }
        :host([open]) .backdrop { opacity: 1; pointer-events: all; }
        .modal-container { width: 90%; max-width: 400px; display: flex; flex-direction: column; gap: 16px; transform: translateY(20px); transition: transform 0.3s ease; }
        :host([open]) .modal-container { transform: translateY(0); }
        .modal-header { background-color: var(--primary-light); color: var(--primary-color); padding: 16px 20px; border-radius: var(--radius-sm); display: flex; justify-content: space-between; align-items: center; font-weight: 600; font-size: 0.95rem; text-transform: uppercase; box-shadow: var(--shadow-lg); }
        .close-btn { cursor: pointer; width: 24px; height: 24px; display: flex; align-items: center; justify-content: center; }
        .close-btn svg { width: 20px; height: 20px; stroke: var(--primary-color); stroke-width: 2; }
    `);
customElements.define("winzer-modal", Z);
class K extends m {
  render() {
    return c`
            <div class="card ${this.featured ? "featured" : ""}">
                <div class="header"><span>${this.category}</span><span>${this.date}</span></div>
                <h3>${this.title}</h3>
                <p>${this.text}</p>

                <div class="tags-container">
                    <slot name="tags"></slot>
                </div>

                ${this.hasAttachment ? c`<div class="attachment-icon"><svg viewBox="0 0 24 24"><path d="M16.5 6v11.5c0 2.21-1.79 4-4 4s-4-1.79-4-4V5a2.5 2.5 0 0 1 5 0v10.5c0 .55-.45 1-1 1s-1-.45-1-1V6H10v9.5a2.5 2.5 0 0 0 5 0V5c0-2.21-1.79-4-4-4S7 2.79 7 5v12.5c0 3.04 2.46 5.5 5.5 5.5s5.5-2.46 5.5-5.5V6h-1.5z"/></svg></div>` : ""}
                <div class="action-btn"><svg viewBox="0 0 24 24"><path d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z"/></svg></div>
            </div>
        `;
  }
}
d(K, "properties", {
  category: { type: String },
  date: { type: String },
  title: { type: String },
  text: { type: String },
  hasAttachment: { type: Boolean },
  featured: { type: Boolean }
}), d(K, "styles", f`
        :host { display: block; margin-bottom: 35px; }
        .card { background-color: var(--bg-card); border-radius: var(--radius-card); padding: 20px 20px 40px 20px; position: relative; color: var(--text-main); display: block; }
        .card.featured { border: 1px solid var(--primary-color); background-color: var(--primary-light); }
        .header { display: flex; justify-content: space-between; font-size: 0.8rem; color: var(--text-muted); margin-bottom: 8px; }
        h3 { color: var(--primary-color); margin: 0 0 8px 0; font-size: 1.1rem; font-weight: 600; }
        p { margin: 0; font-size: 0.95rem; line-height: 1.4; color: var(--text-dark); padding-right: 25px; }
        .attachment-icon { position: absolute; right: 20px; top: 50%; transform: translateY(-50%); color: var(--primary-color); }
        .action-btn { position: absolute; bottom: -20px; right: 20px; background-color: var(--primary-color); color: var(--bg-white); width: 48px; height: 48px; border-radius: var(--radius-sm); display: flex; align-items: center; justify-content: center; box-shadow: var(--shadow-md); cursor: pointer; transition: transform 0.1s; z-index: 10; }
        .action-btn:active { transform: scale(0.95); }
        svg { width: 24px; height: 24px; fill: currentColor; }

        /* Slot for tags */
        .tags-container {
            display: flex;
            gap: 8px;
            margin-top: 12px;
            flex-wrap: wrap;
        }
    `);
customElements.define("winzer-card", K);
class J extends m {
  constructor() {
    super(), this.variant = "solid", this.size = "sm", this.removable = !1, this.clickable = !1;
  }
  _handleRemove(e) {
    e.stopPropagation(), this.dispatchEvent(new CustomEvent("remove", { bubbles: !0, composed: !0 }));
  }
  render() {
    const e = [
      "tag",
      this.variant || "solid",
      this.size || "sm",
      this.color || "",
      this.clickable ? "clickable" : ""
    ].filter(Boolean).join(" ");
    return c`
            <div class="${e}">
                <slot name="icon"></slot>
                <span>${this.label}</span>
                <slot></slot>
                ${this.removable ? c`
                    <span class="remove-btn" @click="${this._handleRemove}">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg>
                    </span>
                ` : ""}
            </div>
        `;
  }
}
d(J, "properties", {
  label: { type: String },
  color: { type: String },
  // 'primary', 'secondary', 'success', 'danger', 'warning', 'info', 'light', 'dark'
  variant: { type: String },
  // 'solid' (default), 'outline'
  size: { type: String },
  // 'xs', 'sm' (default), 'md'
  removable: { type: Boolean },
  clickable: { type: Boolean }
}), d(J, "styles", f`
        :host {
            display: inline-flex;
            vertical-align: middle;
            line-height: 0;
        }
        .tag {
            display: flex;
            align-items: center;
            border-radius: 4px;
            font-weight: 600;
            line-height: normal;
            white-space: nowrap;
            border: 1px solid transparent;
            gap: 4px;
            transition: all 0.2s ease;
            box-sizing: border-box;
        }

        /* Sizes */
        .tag.xs { padding: 2px 6px; font-size: 0.65rem; border-radius: 3px; }
        .tag.sm { padding: 4px 8px; font-size: 0.75rem; }
        .tag.md { padding: 6px 10px; font-size: 0.85rem; }

        /* Clickable */
        .tag.clickable { cursor: pointer; }
        .tag.clickable:hover { opacity: 0.9; transform: translateY(-1px); }
        .tag.clickable:active { transform: translateY(0); }

        /* Solid Variants */
        .tag.solid { background-color: var(--bg-card); color: var(--text-main); border-color: var(--border-color); }
        .tag.solid.primary { background-color: var(--primary-light); color: var(--primary-color); border-color: var(--primary-color); }
        .tag.solid.secondary { background-color: var(--secondary-light); color: var(--secondary-color); border-color: var(--secondary-color); }
        .tag.solid.success { background-color: #d4edda; color: #155724; border-color: #c3e6cb; }
        .tag.solid.danger { background-color: #f8d7da; color: #721c24; border-color: #f5c6cb; }
        .tag.solid.warning { background-color: #fff3cd; color: #856404; border-color: #ffeeba; }
        .tag.solid.info { background-color: #d1ecf1; color: #0c5460; border-color: #bee5eb; }
        .tag.solid.light { background-color: #fefefe; color: #818182; border-color: #fdfdfe; }
        .tag.solid.dark { background-color: #d6d8d9; color: #1b1e21; border-color: #c6c8ca; }

        /* Outline Variants */
        .tag.outline { background-color: transparent; }
        .tag.outline.primary { color: var(--primary-color); border-color: var(--primary-color); }
        .tag.outline.secondary { color: var(--secondary-color); border-color: var(--secondary-color); }
        .tag.outline.success { color: #28a745; border-color: #28a745; }
        .tag.outline.danger { color: #dc3545; border-color: #dc3545; }
        .tag.outline.warning { color: #ffc107; border-color: #ffc107; }
        .tag.outline.info { color: #17a2b8; border-color: #17a2b8; }
        .tag.outline.light { color: #f8f9fa; border-color: #f8f9fa; }
        .tag.outline.dark { color: #343a40; border-color: #343a40; }

        /* Icon Slot Styling */
        ::slotted(svg) {
            width: 12px;
            height: 12px;
            fill: currentColor;
            display: block;
        }
        .tag.xs ::slotted(svg) {
            width: 10px;
            height: 10px;
        }
        .tag.md ::slotted(svg) {
            width: 14px;
            height: 14px;
        }

        /* Remove Button */
        .remove-btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin-left: 2px;
            cursor: pointer;
            opacity: 0.6;
            transition: opacity 0.2s;
            border-radius: 50%;
            width: 14px;
            height: 14px;
        }
        .tag.xs .remove-btn {
            width: 10px;
            height: 10px;
            margin-left: 1px;
        }
        .remove-btn:hover { opacity: 1; background-color: rgba(0,0,0,0.1); }
        .remove-btn svg { width: 10px; height: 10px; stroke-width: 3; }
        .tag.xs .remove-btn svg { width: 8px; height: 8px; }
    `);
customElements.define("winzer-tag", J);
class X extends m {
  _handleUserClick() {
    this.dispatchEvent(new CustomEvent("user-click", { bubbles: !0, composed: !0 }));
  }
  render() {
    return c`<div class="top-bar"><div class="logo-placeholder"><span>luumi</span><span>CORE</span></div><div class="title-group"><div class="main-title">${this.mainTitle || ""}</div><div class="sub-title">${this.subTitle || ""}</div></div><svg class="user-icon" @click="${this._handleUserClick}" viewBox="0 0 24 24"><path fill="none" stroke="currentColor" stroke-width="2" d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/><circle cx="12" cy="7" r="4" fill="none" stroke="currentColor" stroke-width="2"/></svg></div>`;
  }
}
d(X, "properties", { mainTitle: { type: String, attribute: "main-title" }, subTitle: { type: String, attribute: "sub-title" } }), d(X, "styles", f`
        :host { display: block; background: var(--bg-white); padding: 10px 20px; border-bottom: 1px solid var(--border-color); }
        .top-bar { display: flex; align-items: center; justify-content: space-between; height: 60px; }
        .logo-placeholder { border: 1px solid var(--primary-color); width: 40px; height: 40px; display: flex; flex-direction: column; align-items: center; justify-content: center; font-size: 8px; color: var(--primary-color); font-weight: bold; line-height: 1; }
        .title-group { text-align: center; }
        .main-title { color: var(--primary-color); font-weight: bold; font-size: 1rem; text-transform: uppercase; }
        .sub-title { font-size: 0.9rem; color: var(--primary-color); }
        .user-icon { width: 32px; height: 32px; color: var(--text-main); cursor: pointer; }
    `);
customElements.define("winzer-header", X);
class Q extends m {
  constructor() {
    super(), this.items = [];
  }
  render() {
    return !this.items || this.items.length === 0 ? c`` : c`
            <div class="nav-bar">
                ${this.items.map((e) => c`
                    <a href="${e.url || "#"}" class="nav-item ${this.activeTab === e.id ? "active" : ""}">
                        ${e.icon}
                        <span>${e.label}</span>
                    </a>
                `)}
            </div>
        `;
  }
}
d(Q, "properties", {
  activeTab: { type: String },
  items: { type: Array }
  // [{ id: 'news', label: 'News', icon: '...', url: '/news' }]
}), d(Q, "styles", f`
        :host { position: fixed; bottom: 0; left: 0; width: 100%; background: var(--bg-white); border-top: 1px solid var(--border-color); padding-bottom: env(safe-area-inset-bottom); z-index: 100; }
        .nav-bar { display: flex; justify-content: space-around; padding: 10px 0; }
        .nav-item { display: flex; flex-direction: column; align-items: center; font-size: 0.7rem; color: var(--text-main); cursor: pointer; width: 80px; text-decoration: none; }
        .nav-item.active { color: var(--primary-color); }
        .nav-item svg { width: 24px; height: 24px; margin-bottom: 4px; fill: none; stroke: currentColor; stroke-width: 2; }
    `);
customElements.define("winzer-nav", Q);
class ee extends m {
  render() {
    return c`<label class="switch"><input type="checkbox" ?checked="${this.checked}" @change="${(e) => this.checked = e.target.checked}"><span class="slider"></span></label>`;
  }
}
d(ee, "properties", { checked: { type: Boolean } }), d(ee, "styles", f`
        .switch { position: relative; display: inline-block; width: 44px; height: 24px; }
        .switch input { opacity: 0; width: 0; height: 0; }
        .slider { position: absolute; cursor: pointer; top: 0; left: 0; right: 0; bottom: 0; background-color: #ddd; transition: .4s; border-radius: 24px; }
        .slider:before { position: absolute; content: ""; height: 18px; width: 18px; left: 3px; bottom: 3px; background-color: var(--bg-white); transition: .4s; border-radius: 50%; }
        input:checked + .slider { background-color: var(--primary-color); }
        input:checked + .slider:before { transform: translateX(20px); }
    `);
customElements.define("toggle-switch", ee);
class te extends m {
  constructor() {
    super(), this.isUserModalOpen = !1, this.isFilterModalOpen = !1, this.currentTab = "news", this.appTitle = "WINZER-PORTAL", this.appSubtitle = "Badischer Winzerkeller", this.navItems = [
      {
        id: "news",
        label: "News",
        url: "/news",
        icon: $`<svg viewBox="0 0 24 24"><path d="M19 20H5a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h10a2 2 0 0 1 2-2v1m2 13a2 2 0 0 1-2-2V7m2 13a2 2 0 0 0 2-2V9a2 2 0 0 0-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"/></svg>`
      },
      {
        id: "anlieferung",
        label: "Anlieferung",
        url: "/anlieferung",
        icon: $`<svg viewBox="0 0 24 24"><circle cx="12" cy="10" r="2"/><circle cx="15.5" cy="8" r="2"/><circle cx="8.5" cy="8" r="2"/><circle cx="12" cy="6" r="2"/><circle cx="10" cy="13" r="2"/><circle cx="14" cy="13" r="2"/><circle cx="12" cy="16" r="2"/><path d="M12 2v4" stroke-linecap="round"/></svg>`
      },
      {
        id: "tresor",
        label: "Datei-Tresor",
        url: "/tresor",
        icon: $`<svg viewBox="0 0 24 24"><path d="M22 19a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h5l2 3h9a2 2 0 0 1 2 2z"/><path d="M12 12v3"/><path d="M12 12v-1"/></svg>`
      }
    ], this.menuAccount = [
      { label: "Persönliche Daten", icon: $`<path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/><circle cx="12" cy="7" r="4"/>`, action: "profile" },
      { label: "Sicherheits-Einstellungen", icon: $`<rect x="3" y="11" width="18" height="11" rx="2" ry="2"/><path d="M7 11V7a5 5 0 0 1 10 0v4"/>`, action: "security" },
      { label: "Meine Buchungen", icon: $`<circle cx="12" cy="10" r="2"/><circle cx="15.5" cy="8" r="2"/><circle cx="8.5" cy="8" r="2"/><circle cx="12" cy="6" r="2"/><circle cx="10" cy="13" r="2"/><circle cx="14" cy="13" r="2"/><circle cx="12" cy="16" r="2"/><path d="M12 2v4"/>`, action: "bookings" }
    ], this.menuSession = [
      { label: "Abmelden", icon: $`<path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"/><polyline points="16 17 21 12 16 7"/><line x1="21" y1="12" x2="9" y2="12"/>`, action: "logout" }
    ];
  }
  render() {
    return c`
            <!-- Header -->
            <winzer-header
                    .mainTitle="${this.appTitle}"
                    .subTitle="${this.appSubtitle}"
                    @user-click="${() => this.isUserModalOpen = !0}">
            </winzer-header>

            <div class="content">
                <!-- Dynamic Content Slot -->
                <!--
                   The main content is now injected via the default slot.
                   Contao renders the page content, and it gets placed here.
                -->
                <slot></slot>
            </div>

            <!-- Bottom Nav -->
            <winzer-nav
                    .activeTab="${this.currentTab}"
                    .items="${this.navItems}">
            </winzer-nav>

            <!-- MODAL: USER -->
            <winzer-modal title="Mein Benutzerkonto" ?open="${this.isUserModalOpen}" @close="${() => this.isUserModalOpen = !1}">
                <winzer-menu-group .items="${this.menuAccount}"></winzer-menu-group>
                <winzer-menu-group .items="${this.menuSession}"></winzer-menu-group>
            </winzer-modal>

            <!-- MODAL: FILTER -->
            <winzer-modal title="FILTER - EINSTELLUNGEN" ?open="${this.isFilterModalOpen}" @close="${() => this.isFilterModalOpen = !1}">
                <div class="filter-content">
                    <div class="filter-row">
                        <label>
                            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><rect x="3" y="3" width="7" height="7"></rect><rect x="14" y="3" width="7" height="7"></rect><rect x="14" y="14" width="7" height="7"></rect><rect x="3" y="14" width="7" height="7"></rect></svg>
                            Kategorie:
                        </label>
                        <select class="filter-select">
                            <option>Traubengeld</option>
                            <option>Rechnungen</option>
                        </select>
                    </div>
                    <div class="filter-row">
                        <label>
                            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect><line x1="16" y1="2" x2="16" y2="6"></line><line x1="8" y1="2" x2="8" y2="6"></line><line x1="3" y1="10" x2="21" y2="10"></line></svg>
                            Zeitraum:
                        </label>
                        <select class="filter-select">
                            <option>Letzter Monat</option>
                            <option>Dieses Jahr</option>
                        </select>
                    </div>
                    <div class="filter-row" style="margin-top: 20px;">
                        <label>
                            <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="21" y1="10" x2="3" y2="10"></line><line x1="21" y1="6" x2="3" y2="6"></line><line x1="21" y1="14" x2="3" y2="14"></line><line x1="21" y1="18" x2="3" y2="18"></line><polyline points="18 20 21 23 24 20"></polyline></svg>
                            Sortierung:
                        </label>
                        <select class="filter-select">
                            <option>Datum absteigend</option>
                            <option>Datum aufsteigend</option>
                        </select>
                    </div>

                    <button class="filter-btn" @click="${() => this.isFilterModalOpen = !1}">
                        Filtern
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="5" y1="12" x2="19" y2="12"></line><polyline points="12 5 19 12 12 19"></polyline></svg>
                    </button>
                </div>
            </winzer-modal>
        `;
  }
}
d(te, "properties", {
  isUserModalOpen: { type: Boolean },
  isFilterModalOpen: { type: Boolean },
  currentTab: { type: String },
  // Configurable properties
  appTitle: { type: String, attribute: "app-title" },
  appSubtitle: { type: String, attribute: "app-subtitle" },
  navItems: { type: Array },
  // [{ id, label, icon (svg string), url }]
  menuAccount: { type: Array },
  menuSession: { type: Array }
}), d(te, "styles", f`
        :host {
            display: block;
            background-color: var(--bg-white);
            min-height: 100vh;
            width: 100%;
            position: relative;
        }
        .content { padding: 20px; padding-bottom: 90px; }
        .section-header { display: flex; align-items: center; gap: 12px; margin-bottom: 20px; }
        h1 { font-size: 1.5rem; font-weight: 800; margin: 0; text-transform: uppercase; }
        .abo-label { font-size: 0.8rem; font-weight: 600; margin-left: auto; margin-right: 8px; }

        /* Filter Bar */
        .filter-bar {
            display: flex;
            align-items: center;
            font-size: 0.9rem;
            font-weight: 600;
            margin-bottom: 16px;
            cursor: pointer;
        }
        .filter-icon {
            margin-left: 8px;
            width: 24px;
            height: 24px;
            color: var(--text-dark);
        }

        /* Filter Modal Styles */
        .filter-content {
            background-color: var(--bg-white);
            padding: 16px;
            border-radius: var(--radius-card);
            box-shadow: var(--shadow-sm);
        }
        .filter-row {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 12px;
        }
        .filter-row label {
            display: flex;
            align-items: center;
            font-weight: 700;
            font-size: 0.9rem;
            color: var(--text-dark);
        }
        .filter-row label svg {
            width: 20px;
            height: 20px;
            margin-right: 8px;
            color: var(--primary-color);
        }
        .filter-select {
            background-color: var(--bg-white);
            border: 1px solid var(--border-color);
            border-radius: 8px;
            padding: 8px 12px;
            font-size: 0.9rem;
            color: var(--text-dark);
            width: 160px;
        }
        .filter-btn {
            width: 100%;
            background-color: var(--primary-color);
            color: white;
            border: none;
            border-radius: var(--radius-sm);
            padding: 12px;
            font-weight: 600;
            font-size: 1rem;
            margin-top: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            cursor: pointer;
        }
    `);
customElements.define("winzer-app", te);
console.log("luumiCORE Core Bundle initialized");
class Ee extends m {
  render() {
    return c`<p>Hello from luumiCORE!</p>`;
  }
}
d(Ee, "styles", f`
    :host {
      display: block;
      padding: 16px;
      color: var(--luumicore-text-color, black);
      border: 1px solid var(--luumicore-primary, blue);
    }
  `);
customElements.define("luumicore-element", Ee);
export {
  Ee as LuumicoreElement
};
