import { LitElement, html, css } from 'lit';

export class LuumicoreList extends LitElement {
  static styles = css`
    :host {
      display: block;
    }

    ul {
      list-style: none;
      padding: 0;
      margin: 0;
      border: 1px solid var(--luumicore-border-color, #ddd);
      border-radius: var(--luumicore-border-radius, 8px);
      overflow: hidden;
    }
  `;

  render() {
    return html`
      <ul>
        <slot></slot>
      </ul>
    `;
  }
}

customElements.define('luumicore-list', LuumicoreList);
