import { LitElement, html, css } from 'lit';

export class WinzerCard extends LitElement {
    static properties = {
        category: { type: String },
        date: { type: String },
        title: { type: String },
        text: { type: String },
        hasAttachment: { type: Boolean },
        featured: { type: Boolean }
    };
    static styles = css`
        :host { display: block; margin-bottom: 35px; }
        .card { background-color: var(--bg-card); border-radius: var(--radius-card); padding: 20px 20px 40px 20px; position: relative; color: var(--text-main); display: block; }
        .card.featured { border: 1px solid var(--primary-color); background-color: var(--primary-light); }
        .header { display: flex; justify-content: space-between; font-size: 0.8rem; color: var(--text-muted); margin-bottom: 8px; }
        h3 { color: var(--primary-color); margin: 0 0 8px 0; font-size: 1.1rem; font-weight: 600; }
        p { margin: 0; font-size: 0.95rem; line-height: 1.4; color: var(--text-dark); padding-right: 25px; }
        .attachment-icon { position: absolute; right: 20px; top: 50%; transform: translateY(-50%); color: var(--primary-color); }
        .action-btn { position: absolute; bottom: -20px; right: 20px; background-color: var(--primary-color); color: var(--bg-white); width: 48px; height: 48px; border-radius: var(--radius-sm); display: flex; align-items: center; justify-content: center; box-shadow: var(--shadow-md); cursor: pointer; transition: transform 0.1s; z-index: 10; }
        .action-btn:active { transform: scale(0.95); }
        svg { width: 24px; height: 24px; fill: currentColor; }

        /* Slot for tags */
        .tags-container {
            display: flex;
            gap: 8px;
            margin-top: 12px;
            flex-wrap: wrap;
        }
    `;
    render() {
        return html`
            <div class="card ${this.featured ? 'featured' : ''}">
                <div class="header"><span>${this.category}</span><span>${this.date}</span></div>
                <h3>${this.title}</h3>
                <p>${this.text}</p>

                <div class="tags-container">
                    <slot name="tags"></slot>
                </div>

                ${this.hasAttachment ? html`<div class="attachment-icon"><svg viewBox="0 0 24 24"><path d="M16.5 6v11.5c0 2.21-1.79 4-4 4s-4-1.79-4-4V5a2.5 2.5 0 0 1 5 0v10.5c0 .55-.45 1-1 1s-1-.45-1-1V6H10v9.5a2.5 2.5 0 0 0 5 0V5c0-2.21-1.79-4-4-4S7 2.79 7 5v12.5c0 3.04 2.46 5.5 5.5 5.5s5.5-2.46 5.5-5.5V6h-1.5z"/></svg></div>` : ''}
                <div class="action-btn"><svg viewBox="0 0 24 24"><path d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z"/></svg></div>
            </div>
        `;
    }
}
customElements.define('winzer-card', WinzerCard);
