import { LitElement, html, css, svg } from 'lit';

export class WinzerNav extends LitElement {
    static properties = {
        activeTab: { type: String },
        items: { type: Array } // [{ id: 'news', label: 'News', icon: '...', url: '/news' }]
    };

    static styles = css`
        :host { position: fixed; bottom: 0; left: 0; width: 100%; background: var(--bg-white); border-top: 1px solid var(--border-color); padding-bottom: env(safe-area-inset-bottom); z-index: 100; }
        .nav-bar { display: flex; justify-content: space-around; padding: 10px 0; }
        .nav-item { display: flex; flex-direction: column; align-items: center; font-size: 0.7rem; color: var(--text-main); cursor: pointer; width: 80px; text-decoration: none; }
        .nav-item.active { color: var(--primary-color); }
        .nav-item svg { width: 24px; height: 24px; margin-bottom: 4px; fill: none; stroke: currentColor; stroke-width: 2; }
    `;

    constructor() {
        super();
        this.items = [];
    }

    render() {
        if (!this.items || this.items.length === 0) return html``;

        return html`
            <div class="nav-bar">
                ${this.items.map(item => html`
                    <a href="${item.url || '#'}" class="nav-item ${this.activeTab === item.id ? 'active' : ''}">
                        ${item.icon}
                        <span>${item.label}</span>
                    </a>
                `)}
            </div>
        `;
    }
}
customElements.define('winzer-nav', WinzerNav);
