import { LitElement, html, css } from 'lit';
import '../css/main.css';

// Import components
import './components/card/luumicore-card.js';
import './components/list/luumicore-list.js';
import './components/list/luumicore-list-item.js';

console.log('luumiCORE Core Bundle initialized');

// Example component (kept for reference, can be removed if not needed)
export class LuumicoreElement extends LitElement {
  static styles = css`
    :host {
      display: block;
      padding: 16px;
      color: var(--luumicore-text-color, black);
      border: 1px solid var(--luumicore-primary, blue);
    }
  `;

  render() {
    return html`<p>Hello from luumiCORE!</p>`;
  }
}

customElements.define('luumicore-element', LuumicoreElement);
