import { defineConfig } from 'vite';
import { resolve } from 'path';

export default defineConfig({
  build: {
    outDir: 'public/dist',
    emptyOutDir: true,
    lib: {
      entry: resolve(__dirname, 'assets/js/main.js'),
      name: 'LuumicoreCore',
      fileName: (format) => `luumicore-core.js`,
      formats: ['es'],
    },
    rollupOptions: {
      output: {
        assetFileNames: (assetInfo) => {
          if (assetInfo.name === 'style.css') return 'luumicore-core.css';
          return assetInfo.name;
        },
      },
    },
  },
  server: {
    strictPort: true,
    port: 5173,
    origin: 'http://localhost:5173',
    hmr: {
      host: 'localhost',
    },
  },
});
