<?php

declare(strict_types=1);

/*
 * This file is part of luumiCORE Core Bundle.
 *
 * (c) vonRotenberg
 *
 * @license proprietary
 */

namespace luumicore\CoreBundle\EventListener;

use Contao\CoreBundle\Routing\ScopeMatcher;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Component\HttpKernel\Event\ResponseEvent;
use Symfony\Component\HttpKernel\KernelEvents;

#[AsEventListener(KernelEvents::RESPONSE)]
class FrontendAssetsListener
{
    public function __construct(
        private readonly ScopeMatcher $scopeMatcher,
    ) {
    }

    public function __invoke(ResponseEvent $event): void
    {
        if (!$event->isMainRequest()) {
            return;
        }

        $request = $event->getRequest();

        if (!$this->scopeMatcher->isFrontendRequest($request)) {
            return;
        }

        $response = $event->getResponse();
        $content = $response->getContent();

        if (false === $content) {
            return;
        }

        $contentType = $response->headers->get('Content-Type');

        // If Content-Type is present, it must be text/html
        if (null !== $contentType && !str_contains($contentType, 'text/html')) {
            return;
        }

        // If Content-Type is missing, check request format
        if (null === $contentType && 'html' !== $request->getRequestFormat()) {
            return;
        }

        // Inject CSS before </head>
        $css = '<link rel="stylesheet" href="/bundles/luumicorecore/dist/luumicore-core.css">';
        $content = str_ireplace('</head>', $css . "\n</head>", $content);

        // Inject JS before </body>
        $js = '<script type="module" src="/bundles/luumicorecore/dist/luumicore-core.js"></script>';
        $content = str_ireplace('</body>', $js . "\n</body>", $content);

        $response->setContent($content);
    }
}
