<?php

/*
 * This file is part of eSales Media ContentHelperBundle
 *
 * (c) John Doe
 *
 * @license LGPL-3.0-or-later
 */

namespace EsalesMedia\ContaoSwiperBundle\ContaoManager;

use Contao\CoreBundle\ContaoCoreBundle;
use Contao\ManagerPlugin\Bundle\BundlePluginInterface;
use Contao\ManagerPlugin\Bundle\Config\BundleConfig;
use Contao\ManagerPlugin\Bundle\Parser\ParserInterface;
use EsalesMedia\ContaoSwiperBundle\EsalesMediaContaoSwiperBundle;
use MadeYourDay\RockSolidColumns\RockSolidColumnsBundle;

class Plugin implements BundlePluginInterface
{
    /**
     * {@inheritdoc}
     */
    public function getBundles(ParserInterface $parser)
    {
        $arrLoadAfter = [ContaoCoreBundle::class];

        if (RockSolidColumnsBundle::class)
        {
            $arrLoadAfter[] = RockSolidColumnsBundle::class;
        }

        return [
            BundleConfig::create(EsalesMediaContaoSwiperBundle::class)
                ->setLoadAfter($arrLoadAfter)
        ];
    }
}
