<?php

/**
 * Slick slider for Contao
 *
 * Copyright (c) 2016 Benjamin Roth
 *
 * @license LGPL-3.0+
 */

namespace EsalesMedia\ContaoSwiperBundle\Frontend\Element;


/**
 * Front end content element swiper slider start.
 */
class ContentSwiperSliderStart extends \ContentElement
{

	/**
	 * Template
	 * @var string
	 */
	protected $strTemplate = 'ce_swiper_slider_start';


	/**
	 * Generate the content element
	 */
	protected function compile()
	{
		if (TL_MODE == 'BE')
		{
			$this->strTemplate = 'be_wildcard';

			/** @var \BackendTemplate|object $objTemplate */
			$objTemplate = new \BackendTemplate($this->strTemplate);

			$this->Template = $objTemplate;
			$this->Template->title = $this->headline;
		}

    $parentKey = ($this->arrData['ptable'] ?: 'tl_article') . '__' . $this->arrData['pid'];

    if (!empty($GLOBALS['TL_ESM_SLICK'][$parentKey])) {
      $GLOBALS['TL_ESM_SLICK_STACK'][$parentKey][] = $GLOBALS['TL_ESM_SLICK'][$parentKey];
    }

    $GLOBALS['TL_ESM_SLICK'][$parentKey] = $this->id;

		// Slider configuration
		$this->Template->config = $this->eSM_slider_autoPlaySpeed . ',' . $this->eSM_slider_speed . ',' . $this->eSM_slider_initialSlide . ',' . $this->eSM_slider_preload . ',' . $this->eSM_slider_infinite . ',' . $this->eSM_slider_arrows . ',' . $this->eSM_slider_pagination . ',' . $this->eSM_slider_stopOnInteraction . ',' . $this->eSM_slider_fade . ',' . $this->eSM_slider_slidesToShow . ',' . $this->eSM_slider_slidesToScroll . ',' . $this->eSM_slider_adaptiveHeight;

		// Breakpoint config
    $this->eSM_slider_breakpoints = \StringUtil::deserialize($this->eSM_slider_breakpoints);
    if (is_array($this->eSM_slider_breakpoints))
    {
      $arrBreakpoints = array();

      foreach ($this->eSM_slider_breakpoints as $breakpoint)
      {
        if (is_numeric($breakpoint['breakpoint_width']) && is_numeric($breakpoint['breakpoint_slidesToShow']) && is_numeric($breakpoint['breakpoint_slidesToScroll']))
        {
          $arrBreakpoints[$breakpoint['breakpoint_width']] = array('slidesPerView'=>$breakpoint['breakpoint_slidesToShow'],'slidesPerGroup'=>$breakpoint['breakpoint_slidesToScroll']);
        }
      }

      if (count($arrBreakpoints))
      {
        $this->Template->breakpoints = json_encode($arrBreakpoints,JSON_NUMERIC_CHECK );
      }
    }

		// Background image
    if ($this->eSM_addImage && $this->multiSRC)
    {
      $source = \StringUtil::deserialize($this->multiSRC);
      $objFiles = \FilesModel::findMultipleByUuids($source);

      $imageFiles = array();
      $videoFiles = array();

      if ($objFiles !== null) {

        foreach ($objFiles as $file) {
          if (is_file(TL_ROOT . '/' . $file->path))
          {
            if (in_array($file->extension, array_map('trim', explode(',', \Config::get('validImageTypes')))))
            {
              $imageFiles[] = $file;
            } else if (in_array($file->extension, array_map('trim', array('mp4', 'm4v', 'mov', 'wmv', 'webm', 'ogv', 'm4a', 'mp3', 'wma', 'mpeg', 'wav', 'ogg'))))
            {
              $videoFiles[] = $file;
            }
          }
        }
      }

      if (isset($imageFiles[0]))
      {
        $this->singleSRC = $imageFiles[0]->path;

        $this->addImageToTemplate($this->Template, array('singleSRC' => $this->singleSRC, 'size' => $this->size));

        if ($this->eSM_slider_minHeight)
        {
          if ($this->eSM_slider_bgSize && $this->eSM_slider_bgSize == 'auto auto')
          {
            $this->Template->minHeight = $this->Template->picture['img']['height'] . 'px';
          } else
          {
            $this->Template->minHeight = round($this->Template->picture['img']['height'] / $this->Template->picture['img']['width'] * 100) . '%';
          }
        }

        $backgroundStyle = 'background-image: url(\'' . $this->Template->src . '\');';

        if ($this->eSM_slider_bgSize)
        {
          $backgroundStyle .= 'background-size: ' . $this->eSM_slider_bgSize . ';';
        } else
        {
          $backgroundStyle .= 'background-size: cover;';
        }
        if ($this->eSM_slider_bgPosition)
        {
          $backgroundStyle .= 'background-position: ' . $this->eSM_slider_bgPosition . ';';
        } else
        {
          $backgroundStyle .= 'background-position: 0 0;';
        }
        if ($this->eSM_slider_bgOpacity)
        {
          $backgroundStyle .= 'opacity:' . $this->eSM_slider_bgOpacity / 100 . ';';
        }
        if ($this->eSM_slider_bgRepeat)
        {
          $backgroundStyle .= 'background-repeat: ' . $this->eSM_slider_bgRepeat . ';';
        }

        $this->Template->backgroundStyle = $backgroundStyle;
      }

      if (count($videoFiles)) {
        $this->Template->videoFiles = $videoFiles;
      }
    }
	}
}
