<?php

/**
 * Slick slider for Contao
 *
 * Copyright (c) 2016 Benjamin Roth
 *
 * @license LGPL-3.0+
 */

namespace eSM_swiper;


/**
 * Front end content element swiper slider end.
 */
class ContentSwiperSliderStop extends \ContentElement
{

	/**
	 * Template
	 * @var string
	 */
	protected $strTemplate = 'ce_swiper_slider_stop';

  public function generate()
  {
    if (TL_MODE === 'BE') {
      return parent::generate();
    }

    $parentKey = ($this->arrData['ptable'] ?: 'tl_article') . '__' . $this->arrData['pid'];

    if (isset($GLOBALS['TL_ESM_SLICK'][$parentKey])) {
      unset($GLOBALS['TL_ESM_SLICK'][$parentKey]);
    }

    if (!empty($GLOBALS['TL_ESM_SLICK_STACK'][$parentKey])) {
      $GLOBALS['TL_ESM_SLICK'][$parentKey] = array_pop($GLOBALS['TL_ESM_SLICK_STACK'][$parentKey]);
    }

    return parent::generate();
  }


  /**
	 * Generate the content element
	 */
	protected function compile()
	{
		if (TL_MODE == 'BE')
		{
			$this->strTemplate = 'be_wildcard';

			/** @var \BackendTemplate|object $objTemplate */
			$objTemplate = new \BackendTemplate($this->strTemplate);

			$this->Template = $objTemplate;
			$this->Template->title = $this->headline;
		}
	}
}
