<?php

/**
 * eSales Media Formilicious for Contao Open Source CMS
 *
 * Copyright (C) 2013-2014 eSalesMedia
 *
 * @package    eSM_formilicious
 * @link       http://www.esales-media.de
 * @license    http://www.gnu.org/licenses/lgpl-3.0.html LGPL
 *
 * @author     Benjamin Roth <benjamin@esales-media.de>
 */

namespace eSM_formilicious;

use Contao\Controller;
use Contao\DataContainer;

class FormiliciousHooks extends \Controller
{

	/**
	 * Array containing all fields which shouldn't use Formilicous extensions
	 * @var array
	 */
	protected $arrNoFl = array('__selector__','fieldsetfsStart','fieldsetfsStop','hidden','html','headline');

	/**
	 * Array containing all fields which shouldn't use Formilicous custom class
	 * @var array
	 */
	protected $arrNoCustClass = array('explanation');

	/**
	 * Hook for adding Formilicious fields to the form editor
	 * @param $strName
	 */
	public function eSMLoadDataContainer($strName)
	{
		if ($strName != 'tl_form_field')
		{
			return;
		}

		// Hook in the Formilicious fields
		if (is_array($GLOBALS['TL_DCA']['tl_form_field']['palettes']))
		{
			foreach (array_keys($GLOBALS['TL_DCA']['tl_form_field']['palettes']) as $k)
			{
				if (!in_array($k,$this->arrNoFl))
				{
					$strFl = ';{formilicious_legend},eSM_fl_width,eSM_fl_clear';
					if (!in_array($k,$this->arrNoCustClass))
					{
						$strFl.= ',eSM_fl_class';
					}
					if ($k == 'submit')
					{
						$strFl.= ',eSM_fl_lblpadding,eSM_fl_alignment';
					}
					$intPos = strpos($GLOBALS['TL_DCA']['tl_form_field']['palettes'][$k], ';{expert_legend');
					$intDupe = strpos($GLOBALS['TL_DCA']['tl_form_field']['palettes'][$k], ';{formilicious_legend');
					if ($intPos !== false && $intDupe === false)
					{
						$GLOBALS['TL_DCA']['tl_form_field']['palettes'][$k] =
							substr($GLOBALS['TL_DCA']['tl_form_field']['palettes'][$k], 0, $intPos) .
							$strFl .
							substr($GLOBALS['TL_DCA']['tl_form_field']['palettes'][$k], $intPos);
					}
					else if ($intDupe === false)
					{
						$GLOBALS['TL_DCA']['tl_form_field']['palettes'][$k] .= $strFl;
					}
				}
			}
		}
	}

  /**
   * Hook for adding default value functionality to single value select fields
   * @param \Widget $objWidget
   * @param $strForm
   * @param $arrForm
   * @return \Widget
   */
  public function eSMLoadFormField(\Widget $objWidget, $strForm, $arrForm)
  {
    // Only apply to select fields with multiple off
    if ($objWidget->type == 'select' && !$objWidget->multiple && $objWidget->value != '')
    {
      $arrOptions = (array) $objWidget->options;
      $intSelOption = null;

      // Iterate options and search for selected values
      foreach ($arrOptions as $k => $option)
      {
        if (!$option['group'] && $option['value'] == $objWidget->value)
        {
          $intSelOption = $k;
          break;
        } else if (!$option['group'] && $option['default'])
        {
          $intSelOption = $k;
        }
        unset($arrOptions[$k]['default']);
      }

      // Set proper default option
      if ($intSelOption !== null)
      {
        $arrOptions[$intSelOption]['default'] = '1';
      }

      // Override widget with new options array
      $objWidget->options = $arrOptions;
    }

    return $objWidget;
  }

  /**
   * @param array               $arrAttributes
   * @param DataContainer|null  $objDca
   *
   * @return array
   */
  public function eSMGetAttributesFromDca($arrAttributes, $objDca)
  {
    if ($objDca instanceof DataContainer && $objDca->field)
    {
      Controller::loadDataContainer($objDca->table);
      $arrData = $GLOBALS['TL_DCA'][$objDca->table]['fields'][$objDca->field];

      if (isset($arrData['eval']['eSM_fl_width']))
      {
        $arrAttributes['eSM_fl_width'] = $arrData['eval']['eSM_fl_width'];
      }

      if (isset($arrData['eval']['eSM_fl_clear']))
      {
        $arrAttributes['eSM_fl_clear'] = $arrData['eval']['eSM_fl_clear'];
      }

      if (isset($arrData['eval']['eSM_fl_class']))
      {
        $arrAttributes['eSM_fl_class'] = $arrData['eval']['eSM_fl_class'];
      }

      if (isset($arrData['eval']['eSM_fl_lblpadding']))
      {
        $arrAttributes['eSM_fl_lblpadding'] = $arrData['eval']['eSM_fl_lblpadding'];
      }

      if (isset($arrData['eval']['eSM_fl_alignment']))
      {
        $arrAttributes['eSM_fl_alignment'] = $arrData['eval']['eSM_fl_alignment'];
      }

      if (isset($arrData['eval']['eSM_fl_fieldClass']))
      {
        $arrAttributes['class'] = trim($arrAttributes['class'].' '.$arrData['eval']['eSM_fl_fieldClass']);
      }
    }
    return $arrAttributes;
  }
}