<?php

/**
 * eSales Media Cookie Policy
 *
 * Copyright (C) 2013-2015 eSalesMedia
 *
 * @package    eSM_cookiepolicy
 * @link       http://www.esales-media.de
 * @license    commercial
 *
 * @author     Benjamin Roth <benjamin@esales-media.de>
 */

namespace eSM_cookiepolicy;

/**
 * AJAX check
 */

if(!$_SERVER['HTTP_X_REQUESTED_WITH'] || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) != 'xmlhttprequest') {
	header('HTTP/1.1 403 Forbidden');
	die("File cannot be executed directly");
}


/**
 * Initialize the system
 */

define('TL_MODE', 'FE');
require '../../../initialize.php';

class CookiePolicyAsync extends \Frontend
{
	public function __construct()
	{
		\Controller::setStaticUrls();
		\Controller::loadLanguageFile('default');

		parent::__construct();
	}

	public function run()
	{
		$strBuffer = '';
		switch(\Input::get('do'))
		{
			case 'cookiepolicy_authentication':
				if (!is_null(\Input::get('cookiepolicy_commit')))
				{
					$strBuffer = json_encode(array('status'=>(CookiePolicy::ajaxPassCookiePolicy() ? 'OK' : 'FAILED')));
				} else {
					$this->preconditionFailed();
				}
				break;

			default:
				$this->preconditionFailed();
				break;
		}

		header('Content-Type: application/json; charset=utf-8');
		echo $strBuffer;
		exit;
	}

	protected function preconditionFailed()
	{
		header('HTTP/1.1 412 Precondition Failed');
		echo 'Community: Precondition failed';
		exit();
	}
}

$Ajax = new CookiePolicyAsync();
$Ajax->run();