<?php

/**
* eSales Media Cookie Policy
*
* Copyright (C) 2013-2015 eSalesMedia
*
* @package    eSM_cookiepolicy
* @link       http://www.esales-media.de
* @license    commercial
*
* @author     Benjamin Roth <benjamin@esales-media.de>
*/

namespace eSM_cookiepolicy;


/**
 * Class CookiePolicy
 */
class CookiePolicy extends \Frontend
{

	/**
	 * Template
	 * @var string
	 */
	protected $strTemplate = 'cookiepolicy_dialog';


	/**
	 * Cookie policy check
	 */
	public function cookiePolicyCheck(\PageModel $objPage, \LayoutModel $objLayout, \PageRegular $objPageRegular)
	{
		// Skip cookie policy if passed before
		if ($this->Input->cookie('eSM_cookiepolicy_passed') || $objPage->esm_cookiepolicy_ignore)
		{
			return;
		}

		// Get root page
		$objRootPage = $this->getRootPageFromUrl();

		// Don't check if cookie policy is disabled
		if (!$objRootPage->esm_cookiepolicy_check)
		{
			return;
		}

		// Get cookie policy page
		$objPolicyPage = \PageModel::findByPk($objRootPage->esm_cookiepolicy_jumpTo);

		// Load dialog template
		$objTemplate = new \FrontendTemplate($this->strTemplate);
		
		// Set template vars
		$objTemplate->title = $GLOBALS['TL_LANG']['MSC']['esm_cookiepolicy']['title'];
		$objTemplate->text = sprintf($GLOBALS['TL_LANG']['MSC']['esm_cookiepolicy']['text'], $this->generateFrontendUrl($objPolicyPage->row()));
		$objTemplate->btn_confirm = $GLOBALS['TL_LANG']['MSC']['esm_cookiepolicy']['btn_confirm'];
		$objTemplate->commitURL = 'system/modules/eSM_cookiepolicy/ajax/Ajax.php?do=cookiepolicy_authentication&cookiepolicy_commit='.$this->createToken();

		// Add dialog code to page
		$GLOBALS['TL_JQUERY'][] = $objTemplate->parse();


	}

	public static function ajaxPassCookiePolicy()
	{
		if (!\Input::get('cookiepolicy_commit'))
			return false;

		if (\Input::get('cookiepolicy_commit') == $_SESSION['eSM_cookiepolicy_token'])
		{
			preg_match('/(?P<domain>[a-z0-9][a-z0-9\-]{1,63}\.[a-z\.]{2,6})$/i', \Environment::get('host'), $regs);

			setcookie('eSM_cookiepolicy_passed', true, time()+31536000, '/','.'.$regs['domain']);
			unset($_SESSION['eSM_cookiepolicy_token']);

			return true;
		}
	}
	
	protected function createToken()
	{
		if (!$_SESSION['eSM_cookiepolicy_token'])
		{
			$length = 32;
			$characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
			$random_string = "";
			for ($p = 0; $p < $length; $p++)
			{
				$random_string .= $characters[mt_rand(0, strlen($characters))];
			}
			$_SESSION['eSM_cookiepolicy_token'] = $random_string;
		}
		return $_SESSION['eSM_cookiepolicy_token'];
	}
}