<?php

/**
* eSales Media Cookie Policy
*
* Copyright (C) 2013-2015 eSalesMedia
*
* @package    eSM_cookiepolicy
* @link       http://www.esales-media.de
* @license    commercial
*
* @author     Benjamin Roth <benjamin@esales-media.de>
*/

namespace eSM_cookiepolicy;


/**
 * Class CookiePolicy
 */
class CookiePolicy extends \Frontend
{

	/**
	 * Template
	 * @var string
	 */
	protected $strTemplate = 'cookiepolicy_dialog';

	/**
	 * Root page object
	 * @var \PageModel|null
	 */
	protected $objRootPage;


	/**
	 * Cookie policy check
	 *
	 * @param \PageModel $objPage
	 * @param \LayoutModel $objLayout
	 * @param \PageRegular $objPageRegular
	 */
	public function cookiePolicyCheck(\PageModel $objPage, \LayoutModel $objLayout, \PageRegular $objPageRegular)
	{
		// Skip cookie policy if passed before
		if ($this->Input->cookie('eSM_cookiepolicy_passed') || $objPage->esm_cookiepolicy_ignore)
		{
			return;
		}

		// Get root page
		$this->objRootPage = $this->getRootPageFromUrl();

		// Don't check if cookie policy is disabled
		if (!$this->objRootPage->esm_cookiepolicy_check)
		{
			return;
		}

		// Load dialog template
		$objTemplate = new \FrontendTemplate($this->strTemplate);
		
		// Set template vars
		$objTemplate->title = $GLOBALS['TL_LANG']['MSC']['esm_cookiepolicy']['title'];
		$objTemplate->text = preg_replace('/(\\n|\\r)/',' ',$this->replacePlaceholders($this->objRootPage->esm_cookiepolicy_text));
		$objTemplate->btn_confirm = $GLOBALS['TL_LANG']['MSC']['esm_cookiepolicy']['btn_confirm'];
		$objTemplate->commitURL = 'system/modules/eSM_cookiepolicy/ajax/Ajax.php?do=cookiepolicy_authentication&cookiepolicy_commit='.$this->createToken();

		// Add dialog css to page
		$GLOBALS['TL_CSS'][] = 'system/modules/eSM_cookiepolicy/assets/css/cp_theme.css||static';

		// Add dialog code to page
		if (!is_array($GLOBALS['TL_BODY']))
		{
			$GLOBALS['TL_BODY'] = array();
		}
		array_unshift($GLOBALS['TL_BODY'],$this->replaceInsertTags($objTemplate->parse(),false));
	}

	/**
	 * Is policy token correct
	 *
	 * @return bool
	 */
	public static function ajaxPassCookiePolicy()
	{
		if (!\Input::get('cookiepolicy_commit'))
		{
			return false;
		}

		if (\Input::get('cookiepolicy_commit') == $_SESSION['eSM_cookiepolicy_token'])
		{
			preg_match('/((?P<subdomain>[a-z0-9][a-z0-9\-]{1,63}|)\.|^)(?P<domain>[a-z0-9][a-z0-9\-]{1,63}\.[a-z\.]{2,6})$/i', \Environment::get('host'), $regs);

			setcookie('eSM_cookiepolicy_passed', true, time()+31536000, '/',$regs['subdomain'].'.'.$regs['domain']);
			unset($_SESSION['eSM_cookiepolicy_token']);

			return true;
		}

		return false;
	}

	/**
	 * Create and return a 32 char token
	 *
	 * @return string
	 */
	protected function createToken()
	{
		if (!$_SESSION['eSM_cookiepolicy_token'])
		{
			$length = 32;
			$characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
			$random_string = "";
			for ($p = 0; $p < $length; $p++)
			{
				$random_string .= $characters[mt_rand(0, strlen($characters))];
			}
			$_SESSION['eSM_cookiepolicy_token'] = $random_string;
		}
		return $_SESSION['eSM_cookiepolicy_token'];
	}

	/**
	 * Replace placeholders
	 *
	 * @param $strString
	 * @return string
	 */
	protected function replacePlaceholders($strString)
	{
		$strReturn = '';

		// Get cookie policy page
		$objPolicyPage = \PageModel::findByPk($this->objRootPage->esm_cookiepolicy_jumpTo);

		// Remove any unwanted tags (especially PHP tags)
		$strString = strip_tags($strString, \Config::get('allowedTags'));

		// Split placeholders
		$arrPlaceholders = preg_split('/(%%[^%]+%%)/', $strString, -1, PREG_SPLIT_DELIM_CAPTURE|PREG_SPLIT_NO_EMPTY);

		// Replace placeholders
		foreach ($arrPlaceholders as $placeholder)
		{
			switch (strtolower($placeholder))
			{
				case '%%url%%':
					$strString = preg_replace('/'.$placeholder.'/i',$this->generateFrontendUrl($objPolicyPage->row()),$strString);
			}
		}

		return $strString;
	}
}